<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Box and Whisker Chart</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array(
        array("label" => "Web Developer", "y" => array(83133, 91830, 115828, 128982, 101381)),
        array("label" => "System Analyst", "y" => array(51910, 60143, 115056, 135450, 85800)),
        array("label" => "Application Engineer", "y" => array(63364, 71653, 91120, 100556, 80757)),
        array("label" => "Aerospace Engineer", "y" => array(82725, 94361, 118683, 129191, 107142)),
        array("label" => "Dentist", "y" => array(116777, 131082, 171679, 194336, 146794))
    );
?>

<script>
    window.onload = function () {
        var chart = new CanvasJS.Chart("chartContainer", {
            animationEnabled: true,
            title:{
                text: "Annual Salary Range - USA"
            },
            axisY: {
                title: "Annual Salary (in USD)",
                prefix: "$",
                interval: 40000,
                labelFormatter: addSymbols
            },
            data: [{
                type: "boxAndWhisker",
                yValueFormatString: "$#,##0",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
        
        function addSymbols(e){
            var suffixes = ["", "K", "M", "B"];
        
            var order = Math.max(Math.floor(Math.log(Math.abs(e.value)) / Math.log(1000)), 0);
            if(order > suffixes.length - 1)
                order = suffixes.length - 1;
        
            var suffix = suffixes[order];
            return CanvasJS.formatNumber(e.value / Math.pow(1000, order)) + suffix;
        }
    }
</script>

<?php include '../footer.php'; ?>